<?php include 'header.php'; ?>

<!-- Breadcrumb Navigasi -->
<div class="mb-6 text-sm">
    <a href="index.php" class="text-blue-600 hover:text-blue-800">Daftar Sekolah</a>
    <span class="text-gray-400 mx-2">/</span>
    <a href="index.php?action=view_class&school_id=<?php echo $class['school_id']; ?>" class="text-blue-600 hover:text-blue-800">Kelas di <?php echo htmlspecialchars($school['name']); ?></a>
    <span class="text-gray-400 mx-2">/</span>
    <span class="text-gray-600 font-semibold">Dashboard</span>
</div>

<!-- Judul Halaman -->
<div class="mb-6 border-b pb-4">
    <h2 class="text-2xl font-bold text-gray-800">Dashboard Kelas: <?php echo htmlspecialchars($class['name']); ?></h2>
    <p class="text-gray-600">KKM (KKTP) untuk kelas ini adalah: <strong><?php echo $class['kktp']; ?></strong></p>
</div>

<!-- Section 1: Daftar Siswa -->
<div class="bg-gray-50 p-6 rounded-xl mb-8 shadow-sm">
    <div class="flex justify-between items-center mb-4">
        <h3 class="text-xl font-semibold text-gray-700">
            <svg class="inline-block w-5 h-5 mr-2 text-gray-500" fill="currentColor" viewBox="0 0 20 20"><path d="M9 6a3 3 0 11-6 0 3 3 0 016 0zM17 6a3 3 0 11-6 0 3 3 0 016 0zM12.93 17c.046-.327.07-.66.07-1a6.97 6.97 0 00-1.5-4.33A5 5 0 0119 16v1h-6.07zM6 11a5 5 0 015 5v1H1v-1a5 5 0 015-5z"></path></svg>
            Daftar Siswa
        </h3>
        <!-- Tombol Tambah Siswa hanya muncul untuk Admin -->
        <a href="index.php?action=add_student_form&class_id=<?php echo $class_id; ?>" class="bg-blue-600 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded-lg transition shadow-sm">
            + Tambah Siswa
        </a>
    </div>
    
    <div class="overflow-x-auto shadow rounded-lg">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-100">
                <tr>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Nama Siswa</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">NIS / NISN</th>
                    <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Aksi</th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                <?php if ($result_students->num_rows > 0): ?>
                    <?php while($student = $result_students->fetch_assoc()): ?>
                    <tr class="hover:bg-gray-50">
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900"><?php echo htmlspecialchars($student['name']); ?></td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?php echo htmlspecialchars($student['student_number']); ?></td>
                        <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                            <?php if ($assessment): ?>
                                <a href="index.php?action=grade_student&student_id=<?php echo $student['id']; ?>" class="text-green-600 hover:text-green-900 font-semibold">Input Nilai</a>
                            <?php else: ?>
                                <span class="text-gray-400 italic">Konfigurasi Asesmen Dulu</span>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endwhile; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="3" class="px-6 py-8 text-center text-gray-500">
                            Belum ada siswa di kelas ini. Silakan tambahkan siswa terlebih dahulu.
                        </td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<!-- Section 2: Konfigurasi Asesmen -->
<div class="bg-yellow-50 p-6 rounded-xl mb-8 shadow-sm border border-yellow-200">
    <h3 class="text-xl font-semibold text-gray-700 mb-4">
        <svg class="inline-block w-5 h-5 mr-2 text-yellow-600" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M11.49 3.17c-.38-1.56-2.6-1.56-2.98 0a1.532 1.532 0 01-2.286.948c-1.372-.836-2.942.734-2.106 2.106.54.886.061 2.042-.947 2.287-1.561.379-1.561 2.6 0 2.978a1.532 1.532 0 01.947 2.287c-.836 1.372.734 2.942 2.106 2.106a1.532 1.532 0 012.287.947c.379 1.561 2.6 1.561 2.978 0a1.533 1.533 0 012.287-.947c1.372.836 2.942-.734 2.106-2.106a1.533 1.533 0 01.947-2.287c1.561-.379 1.561-2.6 0-2.978a1.532 1.532 0 01-.947-2.287c.836-1.372-.734-2.942-2.106-2.106a1.532 1.532 0 01-2.287-.947zM10 13a3 3 0 100-6 3 3 0 000 6z" clip-rule="evenodd"></path></svg>
        Konfigurasi Asesmen
    </h3>
    <?php if ($assessment): ?>
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative mb-4" role="alert">
            <strong class="font-bold">Asesmen telah dikonfigurasi:</strong> <?php echo htmlspecialchars($assessment['name']); ?>
            <p class="text-sm mt-1">Total Soal: PG(<?php echo $assessment['pg_total'];?>), Isian(<?php echo $assessment['isian_total'];?>), Essay(<?php echo $assessment['essay_total'];?>)</p>
        </div>
        <a href="index.php?action=configure_assessment&class_id=<?php echo $class_id; ?>" class="bg-orange-600 hover:bg-orange-700 text-white font-bold py-2 px-4 rounded transition shadow-sm">
            Edit Konfigurasi Asesmen
        </a>
    <?php else: ?>
        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative mb-4" role="alert">
            <strong class="font-bold">Perhatian!</strong> Belum ada konfigurasi asesmen untuk kelas ini. Anda tidak bisa menginput nilai sebelum mengkonfigurasi asesmen.
        </div>
        <a href="index.php?action=configure_assessment&class_id=<?php echo $class_id; ?>" class="bg-green-600 hover:bg-green-700 text-white font-bold py-2 px-4 rounded transition shadow-sm">
            + Buat Konfigurasi Asesmen
        </a>
    <?php endif; ?>
</div>

<!-- Section 3: Rekapitulasi Nilai -->
<div class="bg-green-50 p-6 rounded-xl shadow-sm border border-green-200">
    <h3 class="text-xl font-semibold text-gray-700 mb-4">
        <svg class="inline-block w-5 h-5 mr-2 text-green-600" fill="currentColor" viewBox="0 0 20 20"><path d="M2 11a1 1 0 011-1h2a1 1 0 011 1v5a1 1 0 01-1 1H3a1 1 0 01-1-1v-5zM8 7a1 1 0 011-1h2a1 1 0 011 1v9a1 1 0 01-1 1H9a1 1 0 01-1-1V7zM14 4a1 1 0 011-1h2a1 1 0 011 1v12a1 1 0 01-1 1h-2a1 1 0 01-1-1V4z"></path></svg>
        Rekapitulasi Nilai Siswa
    </h3>
    <?php if ($assessment): ?>
        <p class="text-gray-600 mb-4">Lihat nilai akhir dan status kompetensi untuk semua siswa di kelas ini.</p>
        <div class="flex gap-4">
            <a href="index.php?action=view_class_scores&class_id=<?php echo $class_id; ?>" class="bg-green-600 hover:bg-green-700 text-white font-bold py-2 px-4 rounded-lg transition shadow-sm">
                📊 Lihat Nilai Semua Siswa
            </a>
            <form method="POST" action="index.php?action=generate_sample_scores&class_id=<?php echo $class_id; ?>" onsubmit="return confirm('Apakah Anda yakin ingin mengisi nilai acak untuk semua siswa? Nilai yang ada akan ditimpa.');">
                <button type="submit" class="bg-orange-500 hover:bg-orange-600 text-white font-bold py-2 px-4 rounded-lg transition shadow-sm">
                    🎲 Generate Data Acak (Untuk Testing)
                </button>
            </form>
        </div>
    <?php else: ?>
        <p class="text-gray-500 italic">Anda harus mengkonfigurasi asesmen terlebih dahulu sebelum dapat melihat rekap nilai.</p>
    <?php endif; ?>
</div>

<?php include 'footer.php'; ?>