<?php include 'header.php'; ?>

<div class="mb-6">

<div class="mb-6">
    <?php if (isset($_SESSION['is_viewer']) && $_SESSION['is_viewer']): ?>
        <div class="flex gap-4 items-center">
            <!-- <span class="text-gray-400">|</span> -->
            <a href="index.php?action=viewer_exit_to_admin" class="text-blue-600 hover:text-blue-800 font-semibold">Masuk ke Mode Admin</a>
        </div>
        <h2 class="text-2xl font-bold text-gray-800 mt-2">Laporan Nilai: <?php echo htmlspecialchars($class['name']); ?></h2>
        <p class="text-gray-600">Mode Viewer (Read-Only) | KKM: <?php echo $class['kktp']; ?></p>
    <?php else: ?>
        <a href="index.php?action=view_class_dashboard&class_id=<?php echo $class_id; ?>" class="text-blue-600 hover:text-blue-800">&larr; Kembali ke Dashboard Kelas</a>
        <h2 class="text-2xl font-bold text-gray-800 mt-2">Rekapitulasi Nilai Kelas: <?php echo htmlspecialchars($class['name']); ?></h2>
        <p class="text-gray-600">KKM: <?php echo $class['kktp']; ?></p>
    <?php endif; ?>
</div>
<div class="mb-6 p-4 bg-gray-50 rounded-lg border no-print">
    <form method="GET" action="index.php" class="flex items-center gap-4">
        <input type="hidden" name="action" value="view_class_scores">
        <label for="class_filter" class="font-semibold text-gray-700">Pindah ke Kelas:</label>
        <select name="class_id" id="class_filter" onchange="this.form.submit()" class="p-2 border border-gray-300 rounded-md">
            <?php foreach($all_classes as $c): ?>
                <option value="<?php echo $c['id']; ?>" <?php echo ($c['id'] == $class_id) ? 'selected' : ''; ?>><?php echo htmlspecialchars($c['name']); ?></option>
            <?php endforeach; ?>
        </select>
    </form>
</div>
<div class="flex justify-end mb-6 no-print">
    <button onclick="window.print()" class="bg-gray-600 hover:bg-gray-700 text-white font-bold py-2 px-4 rounded-lg transition">🖨️ Cetak Laporan</button>
</div>
<div class="overflow-x-auto shadow-lg rounded-lg border border-gray-200">
    <table class="min-w-full divide-y divide-gray-200 text-xs table-print">
        <thead class="bg-gray-50 sticky top-0">
            <tr>
                <th rowspan="2" class="px-2 py-2 text-left font-medium text-gray-500 uppercase">Nama Siswa</th>
                <?php foreach($chapters_tps as $chapter): ?>
                    <th colspan="<?php echo count($chapter['tps']); ?>" class="px-2 py-2 text-center font-medium text-gray-700 uppercase border-l"><?php echo htmlspecialchars($chapter['name']); ?></th>
                <?php endforeach; ?>
                <th colspan="<?php echo count($chapters_tps); ?>" class="px-2 py-2 text-center font-medium text-blue-700 uppercase border-l bg-blue-100">Nilai LM (Inputan Guru)</th>
                <th rowspan="2" class="px-2 py-2 text-center font-bold text-red-700 uppercase border-l">Nilai Akhir</th>
                <th rowspan="2" class="px-2 py-2 text-center font-medium text-gray-500 uppercase">Status</th>
                <th rowspan="2" class="px-2 py-2 text-center font-medium text-gray-500 uppercase border-l">Aksi</th>
            </tr>
            <tr>
                <?php foreach($chapters_tps as $chapter): ?>
                    <?php foreach($chapter['tps'] as $tp): ?>
                        <th class="px-1 py-1 text-center font-medium text-gray-600 uppercase border-l border-t" title="<?php echo htmlspecialchars($tp['name']); ?>"><?php $tp_name_parts = explode(' ', $tp['name']); echo end($tp_name_parts); ?></th>
                    <?php endforeach; ?>
                <?php endforeach; ?>
                <?php $lm_counter = 0; foreach($chapters_tps as $chapter): $lm_counter++; ?>
                    <th class="px-2 py-1 text-center font-medium text-blue-600 uppercase border-l border-t bg-blue-50">LM <?php echo $lm_counter; ?></th>
                <?php endforeach; ?>
            </tr>
        </thead>
        <tbody class="bg-white divide-y divide-gray-200">
            <?php if(empty($students)): ?>
                <tr><td colspan="<?php echo $colspan_value; ?>" class="px-6 py-4 text-center text-gray-500">Tidak ada siswa di kelas ini.</td></tr>
            <?php else: ?>
                <?php foreach($students as $student): ?>
                    <?php
                    $final_average = 0;
                    $chapter_finals = $all_scores['chapter'][$student['id']] ?? [];
                    if(!empty($chapter_finals)){
                        $final_average = array_sum($chapter_finals) / count($chapter_finals);
                    }
                    $status = ($final_average >= $class['kktp']) ? 'KOMPETEN' : 'BELUM KOMPETEN';
                    ?>
                    <tr class="hover:bg-gray-50 <?php echo ($selected_student_id == $student['id']) ? 'bg-indigo-50' : ''; ?>">
                        <td class="px-2 py-2 font-medium text-gray-900" title="<?php echo htmlspecialchars($student['student_number']); ?>"><?php echo htmlspecialchars($student['name']); ?></td>
                        <?php foreach($chapters_tps as $chapter): ?>
                            <?php foreach($chapter['tps'] as $tp): ?>
                                <td class="px-1 py-1 text-center border-l"><?php echo isset($all_scores['tp'][$student['id']][$tp['id']]) ? number_format($all_scores['tp'][$student['id']][$tp['id']], 1) : '-'; ?></td>
                            <?php endforeach; ?>
                        <?php endforeach; ?>
                        <?php foreach($chapters_tps as $chapter): ?>
                            <td class="px-2 py-1 text-center font-semibold text-blue-700 border-l"><?php echo isset($all_scores['slm'][$student['id']][$chapter['id']]) ? number_format($all_scores['slm'][$student['id']][$chapter['id']], 2) : '-'; ?></td>
                        <?php endforeach; ?>
                        <td class="px-2 py-2 text-center font-bold text-red-900 border-l"><?php echo ($final_average > 0) ? number_format($final_average, 2) : '-'; ?></td>
                        <td class="px-2 py-2 text-center border-l">
                            <?php if($final_average > 0): ?>
                                <span class="px-1 py-0.5 inline-flex text-xs leading-4 font-semibold rounded-full <?php echo ($status === 'KOMPETEN') ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800'; ?>"><?php echo $status; ?></span>
                            <?php else: ?>
                                <span class="px-1 py-0.5 inline-flex text-xs leading-4 font-semibold rounded-full bg-gray-100 text-gray-800">-</span>
                            <?php endif; ?>
                        </td>
                        <td class="px-2 py-2 text-center border-l">
                            <?php if($selected_student_id == $student['id']): ?>
                                <a href="index.php?action=view_class_scores&class_id=<?php echo $class_id; ?>" class="text-gray-500 hover:text-gray-700 font-semibold">Tutup</a>
                            <?php else: ?>
                                <a href="index.php?action=view_class_scores&class_id=<?php echo $class_id; ?>&student_id=<?php echo $student['id']; ?>" class="text-indigo-600 hover:text-indigo-900 font-semibold">Detail</a>
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endforeach; ?>
            <?php endif; ?>
        </tbody>
    </table>
</div>
<?php if ($selected_student_id && $selected_student_details['name']): ?>
    <div class="mt-8 p-6 bg-blue-50 rounded-xl border border-blue-200 shadow-md no-print">
        <div class="flex justify-between items-center mb-4">
            <h3 class="text-lg font-bold text-blue-800">Deskripsi Materi Asesmen: <?php echo htmlspecialchars($selected_student_details['name']); ?></h3>
            <a href="index.php?action=view_class_scores&class_id=<?php echo $class_id; ?>" class="text-gray-600 hover:text-gray-800 text-sm font-semibold">Tutup Detail</a>
        </div>
        <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
            <div class="bg-white p-4 rounded-lg shadow">
                <h4 class="font-semibold text-gray-700 mb-2 border-b pb-1">Jawaban Tes Global (SAS)</h4>
                <?php if ($selected_student_details['global_answers']): ?>
                    <ul class="text-sm text-gray-600 space-y-1">
                        <li>PG Benar: <span class="font-bold"><?php echo $selected_student_details['global_answers']['pg_correct']; ?></span> dari <?php echo $assessment['pg_total']; ?></li>
                        <li>Isian Benar: <span class="font-bold"><?php echo $selected_student_details['global_answers']['isian_correct']; ?></span> dari <?php echo $assessment['isian_total']; ?></li>
                        <li>Essay Benar: <span class="font-bold"><?php echo $selected_student_details['global_answers']['essay_correct']; ?></span> dari <?php echo $assessment['essay_total']; ?></li>
                    </ul>
                <?php else: ?>
                    <p class="text-sm text-gray-500 italic">Belum ada data jawaban tes global.</p>
                <?php endif; ?>
            </div>
            <div class="bg-white p-4 rounded-lg shadow lg:col-span-2">
                <h4 class="font-semibold text-gray-700 mb-2 border-b pb-1">Deskripsi Lingkup Materi (LM)</h4>
                <?php if ($selected_student_details['lm_descriptions']): ?>
                    <ul class="text-sm text-gray-600 space-y-2">
                        <?php foreach ($selected_student_details['lm_descriptions'] as $lm): ?>
                            <li>
                                <span class="font-semibold text-blue-700"><?php echo htmlspecialchars($lm['name']); ?>:</span>
                                <p class="text-gray-500 mt-1"><?php echo htmlspecialchars($lm['description']); ?></p>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                <?php else: ?>
                    <p class="text-sm text-gray-500 italic">Belum ada deskripsi LM.</p>
                <?php endif; ?>
            </div>
        </div>
        <div class="bg-white p-4 rounded-lg shadow mt-6">
            <h4 class="font-semibold text-gray-700 mb-2 border-b pb-1">Deskripsi Tujuan Pembelajaran (TP)</h4>
            <?php if ($selected_student_details['tp_descriptions']): ?>
                <ul class="text-sm text-gray-600 space-y-2">
                    <?php foreach ($selected_student_details['tp_descriptions'] as $tp): ?>
                        <li>
                            <span class="font-semibold text-indigo-700"><?php echo htmlspecialchars($tp['name']); ?>:</span>
                            <p class="text-gray-500 mt-1"><?php echo htmlspecialchars($tp['description']); ?></p>
                        </li>
                    <?php endforeach; ?>
                </ul>
            <?php else: ?>
                <p class="text-sm text-gray-500 italic">Belum ada deskripsi TP.</p>
            <?php endif; ?>
        </div>
    </div>
<?php endif; ?>

<?php include 'footer.php'; ?>