<?php include 'header.php'; ?>

<div class="mb-6 text-sm">
    <a href="index.php" class="text-blue-600 hover:text-blue-800">Daftar Sekolah</a>
    <span class="text-gray-400 mx-2">/</span>
    <a href="index.php?action=view_class&school_id=<?php echo $class['school_id']; ?>" class="text-blue-600 hover:text-blue-800">Kelas di <?php echo htmlspecialchars($school['name']); ?></a>
    <span class="text-gray-400 mx-2">/</span>
    <a href="index.php?action=view_class_dashboard&class_id=<?php echo $class_id; ?>" class="text-blue-600 hover:text-blue-800">Dashboard</a>
    <span class="text-gray-400 mx-2">/</span>
    <span class="text-gray-600 font-semibold">Input Nilai</span>
</div>

<div class="mb-6 border-b pb-4">
    <h2 class="text-2xl font-bold text-gray-800 mb-2">Input Nilai untuk: <?php echo htmlspecialchars($student['name']); ?></h2>
    <p class="text-gray-600">Kelas: <?php echo htmlspecialchars($student['class_name']); ?> | KKM: <?php echo $student['kktp']; ?></p>
</div>

<div class="p-6 bg-white rounded-xl shadow-lg border border-gray-100">
    <form method="POST" action="index.php" class="space-y-8">
        <input type="hidden" name="process_grade" value="1">
        <input type="hidden" name="student_id" value="<?php echo $student_id; ?>">
        <input type="hidden" name="class_id" value="<?php echo $class_id; ?>">
        <input type="hidden" name="kktp" value="<?php echo $student['kktp']; ?>">
        <input type="hidden" name="assessment_id" value="<?php echo $assessment['id']; ?>">

        <div class="space-y-4 bg-indigo-50 p-6 rounded-xl border-l-4 border-indigo-500">
            <p class="text-xl font-bold text-indigo-800 mb-4">
                <svg class="inline-block w-6 h-6 mr-2" fill="currentColor" viewBox="0 0 20 20"><path d="M10 2a1 1 0 00-1 1v1a1 1 0 002 0V3a1 1 0 00-1-1zM4 5h12a1 1 0 000-2H4a1 1 0 000 2zM3 7a1 1 0 001 1h12a1 1 0 100-2H4a1 1 0 00-1 1zM3 11a1 1 0 001 1h12a1 1 0 100-2H4a1 1 0 00-1 1zM3 15a1 1 0 001 1h12a1 1 0 100-2H4a1 1 0 00-1 1z"></path></svg>
                1. Hasil Tes Global (<?php echo $assessment['type'] ?? 'STS/SAS'; ?>)
            </p>

            <div class="grid grid-cols-3 gap-6">
                <div>
                    <label for="pg_correct" class="block text-sm font-medium text-gray-700">PG Benar (Max: <?php echo $assessment['pg_max']; ?>)</label>
                    <input type="number" id="pg_correct" name="pg_correct" min="0" max="<?php echo $assessment['pg_max']; ?>" required 
                        value="<?php echo $existing_global['pg_correct']; ?>"
                        class="mt-1 p-3 block w-full border-gray-300 rounded-md shadow-sm">
                </div>
                <div>
                    <label for="isian_correct" class="block text-sm font-medium text-gray-700">Isian Benar (Max: <?php echo $assessment['isian_max']; ?>)</label>
                    <input type="number" id="isian_correct" name="isian_correct" min="0" max="<?php echo $assessment['isian_max']; ?>" required 
                        value="<?php echo $existing_global['isian_correct']; ?>"
                        class="mt-1 p-3 block w-full border-gray-300 rounded-md shadow-sm">
                </div>
                <div>
                    <label for="essay_correct" class="block text-sm font-medium text-gray-700">Esai Benar (Max: <?php echo $assessment['essay_max']; ?>)</label>
                    <input type="number" id="essay_correct" name="essay_correct" min="0" max="<?php echo $assessment['essay_max']; ?>" required 
                        value="<?php echo $existing_global['essay_correct']; ?>"
                        class="mt-1 p-3 block w-full border-gray-300 rounded-md shadow-sm">
                </div>
            </div>
        </div>

        <div class="space-y-4 bg-purple-50 p-6 rounded-xl border-l-4 border-purple-500">
            <p class="text-xl font-bold text-purple-800 mb-4">
                <svg class="inline-block w-6 h-6 mr-2" fill="currentColor" viewBox="0 0 20 20"><path d="M9 2a1 1 0 000 2h2a1 1 0 100-2H9z"></path><path fill-rule="evenodd" d="M4 5a2 2 0 012-2 1 1 0 000 2H6a2 2 0 100 4h2a2 2 0 100 4h2a1 1 0 100 2 2 2 0 01-2 2H6a2 2 0 01-2-2V5z" clip-rule="evenodd"></path></svg>
                2. Input Nilai SLM/UH per Bab (Skala 0-100)
            </p>
            <?php foreach($assessment['chapters'] as $chapter): ?>
                <div class="flex items-center gap-4 p-3 bg-white rounded-lg shadow-sm">
                    <label for="slm_<?php echo $chapter['id']; ?>" class="flex-1 text-sm font-medium text-gray-700">Nilai SLM/UH: <?php echo htmlspecialchars($chapter['name']); ?> (<?php echo htmlspecialchars($chapter['description']); ?>)</label>
                    <input type="number" id="slm_<?php echo $chapter['id']; ?>" name="slm_<?php echo $chapter['id']; ?>" min="0" max="100" 
                        value="<?php echo $existing_slm[$chapter['id']] ?? 0; ?>"
                        class="w-24 p-2 border-gray-300 rounded-md text-right shadow-sm" required>
                </div>
            <?php endforeach; ?>
        </div>

        <div class="flex justify-end">
            <button type="submit" class="bg-green-600 hover:bg-green-700 text-white font-bold py-3 px-6 rounded-lg shadow-xl transition">
                Proses & Simpan Nilai
            </button>
        </div>
    </form>
</div>

<?php include 'footer.php'; ?>